/******************************************************
 * Processor header file.                             *
 * This file is automatically generated by ArchC      *
 * WITHOUT WARRANTY OF ANY KIND, either express       *
 * or implied.                                        *
 * For more information on ArchC, please visit:       *
 * http://www.archc.org                               *
 *                                                    *
 * The ArchC Team                                     *
 * Computer Systems Laboratory (LSC)                  *
 * IC-UNICAMP                                         *
 * http://www.lsc.ic.unicamp.br                       *
 ******************************************************/

#ifndef _NIOS32_H_
#define _NIOS32_H_

#include <systemc.h>
#include "ac_module.H"
#include "ac_utils.H"
#include "nios32_parms.H"
#include "nios32_arch.H"
#include "nios32_pipe_IF.H"
#include "nios32_pipe_ID.H"
#include "nios32_pipe_EX.H"
#include "nios32_pipe_MEM.H"
#include "nios32_pipe_WB.H"

class nios32: public ac_module, public nios32_arch
{
 private:
  typedef cache_item<nios32_parms::AC_DEC_FIELD_NUMBER> cache_item_t;
  typedef ac_instr<nios32_parms::AC_DEC_FIELD_NUMBER> ac_instr_t;

 public:
  sc_in<bool> clock;
  double period;
  bool has_delayed_load;
  char* delayed_load_program;
  nios32_parms::nios32_isa isa;
  //! Stage declarations.
  nios32_pipe_IF::nios32_pipe_IF pipe_IF;
  ac_sync_reg<ac_instr_t> pr_pipe_IF_pipe_ID;
  nios32_pipe_ID::nios32_pipe_ID pipe_ID;
  ac_sync_reg<ac_instr_t> pr_pipe_ID_pipe_EX;
  nios32_pipe_EX::nios32_pipe_EX pipe_EX;
  ac_sync_reg<ac_instr_t> pr_pipe_EX_pipe_MEM;
  nios32_pipe_MEM::nios32_pipe_MEM pipe_MEM;
  ac_sync_reg<ac_instr_t> pr_pipe_MEM_pipe_WB;
  nios32_pipe_WB::nios32_pipe_WB pipe_WB;
  //! Start simulation.
  void init(int ac, char** av);
  void init();
  //! Program loading.
  void load(char* program);
  void delayed_load(char* program);
  //! Stop simulation (may receive exit status).
  void stop(int status = 0);
  //! PrintStat wrapper method.
  void PrintStat();
  //! Verification method.
  void ac_verify();
  //! Behavior method.
  SC_HAS_PROCESS(nios32);

  //! Constructor.
  nios32(sc_module_name mname, double p): ac_module(mname), period(p), isa(*this, pipe_IF, pr_pipe_IF_pipe_ID, pipe_ID, pr_pipe_ID_pipe_EX, pipe_EX, pr_pipe_EX_pipe_MEM, pipe_MEM, pr_pipe_MEM_pipe_WB, pipe_WB), pipe_IF("nios32_pipe_IF", *this, isa, 0, 0, &pr_pipe_IF_pipe_ID), pipe_ID("nios32_pipe_ID", *this, isa, &pipe_IF, &pr_pipe_IF_pipe_ID, &pr_pipe_ID_pipe_EX), pipe_EX("nios32_pipe_EX", *this, isa, &pipe_ID, &pr_pipe_ID_pipe_EX, &pr_pipe_EX_pipe_MEM), pipe_MEM("nios32_pipe_MEM", *this, isa, &pipe_EX, &pr_pipe_EX_pipe_MEM, &pr_pipe_MEM_pipe_WB), pipe_WB("nios32_pipe_WB", *this, isa, &pipe_MEM, &pr_pipe_MEM_pipe_WB, 0), pr_pipe_IF_pipe_ID("pr_pipe_IF_pipe_ID"), pr_pipe_ID_pipe_EX("pr_pipe_ID_pipe_EX"), pr_pipe_EX_pipe_MEM("pr_pipe_EX_pipe_MEM"), pr_pipe_MEM_pipe_WB("pr_pipe_MEM_pipe_WB")
  {
   pipe_IF.clock(clock);
   pipe_ID.clock(clock);
   pipe_EX.clock(clock);
   pipe_MEM.clock(clock);
   pipe_WB.clock(clock);
   SC_METHOD(ac_verify);
   sensitive << pipe_IF.done << pipe_ID.done << pipe_EX.done << pipe_MEM.done << pipe_WB.done;
   dont_initialize();
   return;
  }

  //! Destructor.
  ~nios32()
  {
   return;
  }
};

#endif // _NIOS32_H_
